--this is a example pendulum, type hammer, used in forest maps (especially tutorial map)
require 'g_level'

function create_hammer(idle_times,from_x,from_y,to_x,to_y,layer) --from x,from y, to x, to y, layer
    local dmg_start_script = "data/scripts/test/srt_start_damage_test.lua"
    local dmg_end_script = "data/scripts/test/srt_stop_damage_test.lua"
    local out_speed = 600.0
    local in_speed = 250.0

    --Pendulum starts
    --hammer starts
    local hammer_1_id = g_level.give_id();
    local hammer_target_layer = layer;
    local hammer_x = from_x;
    local hammer_y = from_y;
    lua:create_hammer(           hammer_1_id, hammer_x, hammer_y, hammer_target_layer)                  -- id , cylinder x , cylinder y

    --shape & trigger
    local hammer_1_circle = "hammer_1_shape";
    local hammer_1_trigger = "hammer_1_trigger";
    lua:create_circle(  hammer_1_circle,   0.0, 0.0, 50.0)                                              --name, x, y, radius
    lua:create_trigger( hammer_1_trigger,  TT_GATE, dmg_start_script,dmg_end_script, 0.0, 0.0)          --name, type, on_enter_script, on_leave_scipt,x,y
    lua:trigger_shape(  hammer_1_trigger,  TT_GATE, hammer_1_circle)                                    --name, type, shape_name
    lua:trigger_add_group_can_use_me(hammer_1_trigger,  TT_GATE, "player")                              --name, type, group_name
    lua:trigger_add_group_i_belong_to(hammer_1_trigger, TT_GATE, "killer")                              --name, type, group_name

    lua:hammer_add_trigger(      hammer_1_id, hammer_1_trigger)                                         -- id, trigger

    for i=1,#idle_times,1 do
        --idle pairs
        lua:hammer_add_idle_pair(    hammer_1_id, idle_times[i], 1.0)                         -- id, idle in before moving out, idle out before moving in
        --speed pairs
        lua:hammer_add_speed_pair(   hammer_1_id, out_speed, in_speed)                     -- id, speed away from cylinder, speed towards cylinder
    end
   
    --start and end locations
    lua:hammer_piston_locations( hammer_1_id, 1.0, 1.0, to_x, to_y)     -- id, startpoint x, startpoint y, endpoint x, endpoint y

    --create animated sprite, but will not place it to layer
    local hammer_cylinder_sprite   = "hammer_cylinder_sprite";
    local hammer_piston_sprite     = "hammer_piston_sprite";
    local hammer_crankshaft_sprite = "hammer_crankshaft_sprite";

    local scale = 1.0
    local cylinder_scale=1.0
    lua:create_sprite(              hammer_cylinder_sprite,  ST_ANIMATED, "hammer_cylinder_animation",  0.0,  0.0)                            --  sprite name, animated or not, animation name, translation x, y
    lua:sprite_shape(               hammer_cylinder_sprite,  ST_ANIMATED,                         64.0 *scale*cylinder_scale, 64.0 *scale*cylinder_scale)                            --  sprite name, animated or not, half width, half height

    local piston_scale = 0.75
    lua:create_sprite(              hammer_piston_sprite,  ST_ANIMATED, "hammer_piston_animation",    0.0,  0.0)                              --  sprite name, animated or not, animation name, translation x, y
    lua:sprite_shape(               hammer_piston_sprite,  ST_ANIMATED,                         64.0*scale*piston_scale, 64.0*scale*piston_scale)                              --  sprite name, animated or not, half width, half height

    local crankshaft_scale = 0.33
    lua:create_sprite(              hammer_crankshaft_sprite, ST_TEXTURED,    "hammer", 0.0, 0.0)                        --  sprite name, animated or not, animation name, translation x, y
    lua:sprite_shape(               hammer_crankshaft_sprite, ST_TEXTURED,    64.0*scale*crankshaft_scale,   64.0*scale*crankshaft_scale)                                              --  sprite name, animated or not, half width, half height
    lua:textured_sprite_tex_coords( hammer_crankshaft_sprite, ST_TEXTURED,     0.5,0.5, 1.0, 1.0)                                    --  code will override this basically

    --set sprite to hammer, will NOT remove it from temporary list
    lua:hammer_set_cylinder_animatedsprite(  hammer_1_id, hammer_cylinder_sprite   )  -- id, animation name
    lua:hammer_set_piston_animatedsprite(    hammer_1_id, hammer_piston_sprite     )  -- id, animation name
    lua:hammer_set_piston_angledifference(   hammer_1_id, 0.45*0.5*3.14            )  -- id, angle(rads)      -- 0.45f * Math::half_pi() -- half_pi = 90degrees
    lua:hammer_set_crankshaft_sprite(        hammer_1_id, hammer_crankshaft_sprite )  -- id, animation name

    --remove from temp list
    lua:gameobject_remove_from_temp_list( hammer_cylinder_sprite   )
    lua:gameobject_remove_from_temp_list( hammer_piston_sprite     )
    lua:gameobject_remove_from_temp_list( hammer_crankshaft_sprite )

    --hammer audio
    local hammer_down_sound =  "hammer_down_sound";
    local hammer_up_sound   =  "hammer_up_sound";
    lua:create_sound(hammer_down_sound, "data/music/effect_stereo.ogg",  500.0, hammer_x, hammer_y)   -- name, music_name, radius ( x and y will be replaced at first update  but good to have real place )
    lua:create_sound(hammer_up_sound, "data/music/effect_stereo.ogg",    500.0, hammer_x, hammer_y)   -- name, music_name, radius ( x and y will be replaced at first update  but good to have real place )

    lua:create_sound_effect(hammer_down_sound, hammer_down_sound, 0.1, true)                         -- object name, sound name, delay, loop
    lua:create_sound_effect(hammer_up_sound, hammer_up_sound, 0.1, true)                             -- object name, sound name, delay, loop

    lua:hammer_add_down_going_sound(hammer_1_id, hammer_down_sound)                                  -- hammer id, flying sound
    lua:hammer_add_down_going_sound(hammer_1_id, hammer_up_sound)                                    -- hammer id, flying sound

    lua:gameobject_remove_from_temp_list( hammer_down_sound )
    lua:gameobject_remove_from_temp_list( hammer_up_sound )
    --hammer ends
end

--LOAD GRAPHICS
--lua_init_texture_animation("hammer_cylinder_animation", "data/images/characters/vampire/idle/", 20, MODE_LOOP, DIRECTION_FORWARD, 0.3, FM_NEAREST, WM_CLAMP, WM_CLAMP, AM_MODULATE)
--lua_init_texture_animation("hammer_piston_animation",  "data/images/characters/vampire/run/",   13, MODE_LOOP, DIRECTION_FORWARD, 0.17, FM_NEAREST, WM_CLAMP, WM_CLAMP, AM_MODULATE)
--lua_init_texture("hammer_crankshaft_texture", "data/images/lantern.png", FM_NEAREST, WM_REPEAT, WM_REPEAT, AM_MODULATE)  -- !! HAVE TO BE REPEAT !!
lua_init_texture("hammer", "data/images/pendulum.png",FM_NEAREST,WM_REPEAT,WM_REPEAT,AM_MODULATE)
lua_init_subtextures("hammer",2,2,1,3) -- using a selfmade lua function to initialize
lua:init_animation("hammer_cylinder_animation",MODE_LOOP, DIRECTION_FORWARD)
lua:animation_add_frame("hammer_cylinder_animation","hammer_3", 0.125)
lua:animation_add_frame("hammer_cylinder_animation","hammer_3", 0.125)


lua:init_animation("hammer_piston_animation",MODE_LOOP, DIRECTION_FORWARD)
lua:animation_add_frame("hammer_piston_animation","hammer_1", 0.125)
lua:animation_add_frame("hammer_piston_animation","hammer_1", 0.125)


